﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

using UnityEngine.UI;  // UIを使用するのに使用
using UnityEngine.SceneManagement;  // シーンの切り替えに使用

//////////////////////////////////////////////////////////////////
//【スコアの管理に使用するクラス】
// 敵を倒した際のスコア追加や、ボス出現やクリアのスコア到達時の処理実行
//////////////////////////////////////////////////////////////////
public class ScoreManager : MonoBehaviour
{
    /////////////////////////////////
    // 【変数の設定】
    /////////////////////////////////

    //【定数の設定】（レベル設計で変更可能）
    const int BOSS_START = 30;  // ボスの出現スコア
    const int BOSS_END = 60;  // ボスの破壊スコア

    //【Unity Editorから設定するPublic変数】
    public EnemyManager class_EnemyManager;  // EnemyManagerの関数呼び出し用
    public Text text_Score;  // UIにスコアを表示するテキスト
    public GameObject gameOver;  // UIにGame Overを表示するテキスト
    public GameObject gameClear;  // UIにGame Clearを表示するテキスト

    //【このプログラム内で使用するPrivate変数】
    private int totalScore = 0;  // 現在のスコア
    private bool isBossMode = false;  // ボスが出現したらtrue
    private bool isGameClear = false;  // ゲームクリアしたらtrue


    /////////////////////////////////
    // 【関数の設定】
    /////////////////////////////////

    //【ゲーム開始時に１回だけ動く関数】
    //（Unityの標準関数）
    void Start()
    {
        // UIのスコアに現在のスコアを表示
        text_Score.text = totalScore.ToString();
    }


    //【敵を倒したときにスコアを追加する関数】
    public void AddScore(int score)
    {
        // 現在のスコアに引数scoreだけ追加
        totalScore += score;
        // UIのスコアに現在のスコアを表示
        text_Score.text = totalScore.ToString();

        // 現在のスコアがボスの出現スコアを超えている場合
        if (totalScore >= BOSS_START)
        {
            // まだボスが出現してない場合
            if (isBossMode == false)
            {
                // ボスが出現させるのでisBossModeをtrueに変更
                isBossMode = true;
                // ボス出現の関数をコルーチンで呼び出す
                //（数秒待ってからボスを出現させるためコルーチンを使用）
                StartCoroutine("Call_CreateBoss");
            }
            
            // 現在のスコアがボスの破壊スコアを超えた場合
            if (totalScore >= BOSS_END)
            {
                // ゲームをクリアしたのでisGameClearをtrueに変更
                isGameClear = true;
                // UIにGame Clearのテキストを表示
                gameClear.SetActive(true);
                // 自動リスタートの関数をコルーチンで呼び出す
                //（数秒待ってからリスタートさせるためコルーチンを使用）
                StartCoroutine("Restart_Game");
            }
        }
    }


    //【敵のビームに衝突した際に他のプログラムから呼ばれるゲームオーバ処理の関数】
    public void GameOver()
    {
        // UIにGame Overのテキストを表示
        gameOver.SetActive(true);
        // 自動リスタートの関数をコルーチンで呼び出す
        //（数秒待ってからリスタートさせるためコルーチンを使用）
        StartCoroutine("Restart_Game");
    }


    //【ゲームオーバ後数秒後にゲームリスタートさせるコルーチン】
    IEnumerator Restart_Game()
    {
        // ゲームリスタート処理の前に数秒待つ
        yield return new WaitForSeconds(9.0f);
        // 同じシーンを再起動させる
        //（もしシーン名を変えている場合は、そのシーン名を使用）
        SceneManager.LoadScene("GameMain");
    }


    //【ボスの出現スコア到達後数秒後にボスを出現させるコルーチン】
    IEnumerator Call_CreateBoss()
    {
        // ボスの出現処理の前に数秒待つ
        yield return new WaitForSeconds(4.0f);
        // EnemyManagerのボス出現の関数を呼び出す
        class_EnemyManager.Create_Boss();
    }


    //【他のプログラムからボスが出現しているか確認する関数】
    public bool Get_BossMode()
    {
        // isBossModeの値を返す
        return isBossMode;
    }

    
    //【他のプログラムからゲームクリアしているか確認する関数】
    public bool Get_GameClear()
    {
        // isGameClearの値を返す
        return isGameClear;
    }
}
