﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

//////////////////////////////////////////////////////////////////
//【敵機の自動作成に使用するクラス】
// 敵機１、２の自動作成とボスの作成処理を実行
//////////////////////////////////////////////////////////////////
public class EnemyManager : MonoBehaviour
{
    /////////////////////////////////
    // 【変数の設定】
    /////////////////////////////////

    //【Unity Editorから設定するPublic変数】
    public GameObject prefab_Enemy1; // 敵機１のプレハブ
    public GameObject prefab_Enemy2; // 敵機２のプレハブ
    public GameObject prefab_Enemy3; // 敵ボスのプレハブ
    public ScoreManager class_ScoreManager; // ScoreManagerの関数呼び出し用


    /////////////////////////////////
    // 【関数の設定】
    /////////////////////////////////

    //【ゲーム開始時に１回だけ動く関数】
    //（Unityの標準関数）
    void Start()
    {
        // 敵機１を繰り返し発生させるコルーチンを呼ぶ
        StartCoroutine("Create_Enemy1");
        // 敵機２を繰り返し発生させるコルーチンを呼ぶ
        StartCoroutine("Create_Enemy2");
    }


    //【敵機１を発生させるコルーチン】
    IEnumerator Create_Enemy1()
    {
        // このコルーチン内だけで使用する変数
        // 敵機１の発生させるX座標をランダムに設定
        float pos_Spoon_X = Random.Range(-2.5f, 2.5f);
        // 次の敵機１を発生させるまでの間隔をランダムに設定
        float time_Wait = Random.Range(1.5f, 2.0f);

        // 敵機１を指定の場所に発生させる
        GameObject instance = (GameObject)Instantiate(prefab_Enemy1,
                                                      new Vector3(pos_Spoon_X, 5.5f, 0.0f),
                                                      Quaternion.identity);
        // プログラムを指定秒停止させる
        yield return new WaitForSeconds(time_Wait);

        // ScoreManagerのisBossModeの値がfalseの場合
        if (class_ScoreManager.Get_BossMode() == false)
            // 再度敵機１を発生させるコルーチンを呼ぶ
            StartCoroutine("Create_Enemy1");
    }


    //【敵機２を発生させるコルーチン】
    IEnumerator Create_Enemy2()
    {
        // このコルーチン内だけで使用する変数
        // 敵機２の発生させるX座標をランダムに設定
        float pos_Spoon_X = Random.Range(-2.5f, 2.5f);
        // 次の敵機２を発生させるまでの間隔をランダムに設定
        float time_Wait = Random.Range(4f, 6f);

        // 敵機２を指定の場所に発生させる
        GameObject instance = (GameObject)Instantiate(prefab_Enemy2,
                                                      new Vector3(pos_Spoon_X, 5.5f, 0.0f),
                                                      Quaternion.identity);
        // プログラムを指定秒停止させる
        yield return new WaitForSeconds(time_Wait);

        // ScoreManagerのisBossModeの値がfalseの場合
        if (class_ScoreManager.Get_BossMode() == false)
            // 再度敵機２を発生させるコルーチンを呼ぶ
            StartCoroutine("Create_Enemy2");
    }


    //【敵ボスを発生させる関数】
    public void Create_Boss()
    {
        // 敵ボスを指定の場所に発生させる
        GameObject instance = (GameObject)Instantiate(prefab_Enemy3,
                                                      new Vector3(0.0f, 6.0f, 0.0f),
                                                      Quaternion.identity);
    }
}
