﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

//////////////////////////////////////////////////////////////////
//【敵ボスのコントロールに使用するクラス】
// 敵ボスを移動させる処理やビーム砲の発射処理、相手ビームとの衝突処理を実行
//////////////////////////////////////////////////////////////////
public class BossController : MonoBehaviour
{
    /////////////////////////////////
    // 【変数の設定】
    /////////////////////////////////

    //【Unity Editorから設定するPublic変数】
    public GameObject prefab_Beam1; // ボスのビーム１のプレハブ
    public GameObject prefab_Beam2; // ボスのビーム２のプレハブ
    public AudioClip sound_BigExplosion;  // ボス爆発の効果音

    //【このプログラム内で使用するPrivate変数】
    private float speed_X = -0.3f; // 敵ボスのX方向（横方向）の移動スピード
    private float speed_Y = -0.3f; // 敵ボスのY方向（縦方向）の移動スピード
    private GameObject gameManager; // Scene上のGameManagerゲームオブジェクト
    private AudioSource audioSource;  // オーディオソース


    /////////////////////////////////
    // 【関数の設定】
    /////////////////////////////////

    //【ボスが出現時に１回だけ動く関数】
    //（Unityの標準関数）
    void Start()
    {
        // Scene上のGameManagerゲームオブジェクトを取得
        //（自機の場合Public変数で事前に関連付けをさせたが、敵機はもともとScene上に
        // ないので敵機が自動作成された際にScene上から取得する）
        gameManager = GameObject.Find("GameManager");
        // GameManagerに付いているAudioSourceコンポーネントを取得
        audioSource = gameManager.GetComponent<AudioSource>();

        // ビーム１を繰り返し発生させるコルーチンを呼ぶ
        StartCoroutine("Create_Beam1");
        // ビーム２を繰り返し発生させるコルーチンを呼ぶ
        StartCoroutine("Create_Beam2");
    }


    //【毎フレームに１度動く関数】
    //（Unityの標準関数）
    void Update()
    {
        // 毎フレーム、X方向（横方向）とY方向（縦方向）に指定の距離だけ移動する
        //（X方向とY方向に スピード×時間＝距離 だけ移動）
        transform.Translate(speed_X * Time.deltaTime, speed_Y * Time.deltaTime, 0);

        // 敵ボスが左端まで行ったら、X方向を右への移動に変更
        if (transform.position.x < -2) speed_X = 0.3f;
        // 敵ボスが右端まで行ったら、X方向を左への移動に変更
        else if (transform.position.x > 2) speed_X = -0.3f;

        // 敵ボスが下端まで行ったら、Y方向を上への移動に変更
        if (transform.position.y < 0) speed_Y = 0.3f;
        // 敵ボスが上端まで行ったら、Y方向を下への移動に変更
        else if (transform.position.y > 4.5) speed_Y = -0.3f;
    }


    //【敵ボスがビームに衝突した際に呼ばれる関数】
    //（Unityの標準関数）
    private void OnTriggerEnter2D(Collider2D other)
    {
        // 衝突した相手のゲームオブジェクトのタグがBeam_Fighterの場合
        if (other.gameObject.tag == "Beam_Fighter")
        {
            // 指定のスコアを追加する関数を呼び出す
            gameManager.GetComponent<ScoreManager>().AddScore(1);

            // ScoreManagerのisGameClearの値がtrueの場合
            if (gameManager.GetComponent<ScoreManager>().Get_GameClear() == true)
            {
                // ボス爆発の効果音を１回流す
                audioSource.PlayOneShot(sound_BigExplosion);
                // 敵ボスのゲームオブジェクトを削除する
                Destroy(gameObject);
            }
        }
    }


    //【ビーム１を発生させるコルーチン】
    IEnumerator Create_Beam1()
    {
        // ビーム１の作成する基準位置をボスの位置とする
        Vector3 sporn_Position = transform.position;
        // ビーム１の１つ目の作成位置を基準位置の少し右にする
        sporn_Position.x = transform.position.x + 0.5f;
        // ビーム１のプレハブをシーン上に作成する
        Instantiate(prefab_Beam1, sporn_Position, Quaternion.identity);

        // ビーム１の２つ目の作成位置を基準位置の少し左にする
        sporn_Position.x = transform.position.x - 0.5f;
        // ビーム１のプレハブをシーン上に作成する
        Instantiate(prefab_Beam1, sporn_Position, Quaternion.identity);

        // プログラムを指定秒停止させる
        yield return new WaitForSeconds(0.7f);

        // 再度ビーム１を発生させるコルーチンを呼ぶ
        StartCoroutine("Create_Beam1");
    }


    //【ビーム２を発生させるコルーチン】
    IEnumerator Create_Beam2()
    {
        // ビーム２のプレハブをシーン上に作成する
        Instantiate(prefab_Beam2, transform.position, Quaternion.identity);
        // プログラムを指定秒停止させる
        yield return new WaitForSeconds(0.6f);

        // 再度ビーム２を発生させるコルーチンを呼ぶ
        StartCoroutine("Create_Beam2");
    }
}
