﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

//////////////////////////////////////////////////////////////////
//【背景を無限スクロールさせるクラス】
// 背景を下に移動させ、下端で自動的に上端に移動させる処理の実行
//////////////////////////////////////////////////////////////////
public class BackImageController : MonoBehaviour
{
    /////////////////////////////////
    // 【変数の設定】
    /////////////////////////////////

    //【定数の設定】（レベル設計で変更可能）
    const float BACK_SPEED = -1.0f;  // 背景の移動スピード
    const float START_POSITION = 22;  // 背景の移動開始の位置
    const float END_POSITION = -14;  // 背景の移動終了の位置


    /////////////////////////////////
    // 【関数の設定】
    /////////////////////////////////

    //【毎フレームに１度動く関数】
    //（Unityの標準関数）
    // 毎フレーム、移動スピードだけ背景を移動させる
    // その移動時に背景が移動終了位置に達したかを確認する
    void Update()
    {
        // 縦軸方向へ移動スピードだけ移動する
        transform.Translate(0, BACK_SPEED * Time.deltaTime, 0);

        // 背景が移動終了の位置に達したら移動開始位置へ動かす処理を呼ぶ
        if (transform.position.y <= END_POSITION) ScrollEnd();
    }


    //【背景を移動終了の位置から移動開始の位置へ動かす関数】
    private void ScrollEnd()
    {
        // 背景を移動した距離（終了位置ー開始位置）だけ逆に戻す
        transform.Translate(0, -1 * (END_POSITION - START_POSITION), 0);
    }
}
